/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.c.CreepyDollEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CreepyDollTriggeredAbility
extends TriggeredAbilityImpl {
    CreepyDollTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreepyDollEffect());
    }

    private CreepyDollTriggeredAbility(CreepyDollTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CreepyDollTriggeredAbility copy() {
        return new CreepyDollTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isCreature(game) && ((DamagedEvent)event).isCombatDamage() && event.getSourceId().equals(this.sourceId)) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} deals combat damage to a creature, flip a coin. If you win the flip, destroy that creature.";
    }
}

