/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessTargetEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CreepyPuppeteerTriggeredAbility
extends TriggeredAbilityImpl {
    CreepyPuppeteerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new SetBasePowerToughnessTargetEffect(4, 3, Duration.EndOfTurn), true);
    }

    private CreepyPuppeteerTriggeredAbility(CreepyPuppeteerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CreepyPuppeteerTriggeredAbility copy() {
        return new CreepyPuppeteerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(game.getCombat().getAttackingPlayerId()) || !game.getCombat().getAttackers().contains(this.getSourceId()) || game.getCombat().getAttackers().size() != 2) {
            return false;
        }
        UUID otherAttacker = game.getCombat().getAttackers().stream().filter(uuid -> !this.getSourceId().equals(uuid)).findFirst().orElse(null);
        if (otherAttacker == null) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(otherAttacker, game));
        return true;
    }

    public String getRule() {
        return "Whenever {this} attacks, if you attacked with exactly one other creature this combat, you may have that creature's base power and toughness become 4/3 until end of turn.";
    }
}

