/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CrownOfDoomEffect
extends OneShotEffect {
    CrownOfDoomEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target player other than {this}'s owner gains control of it";
    }

    private CrownOfDoomEffect(CrownOfDoomEffect effect) {
        super((OneShotEffect)effect);
    }

    public CrownOfDoomEffect copy() {
        return new CrownOfDoomEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player newController = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && newController != null && !Objects.equals(controller.getId(), newController.getId())) {
            GainControlTargetEffect effect = new GainControlTargetEffect(Duration.Custom, newController.getId());
            effect.setTargetPointer((TargetPointer)new FixedTarget(source.getSourceId(), game));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

