/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.c.CrownOfEmpiresControlEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class CrownOfEmpiresEffect
extends OneShotEffect {
    CrownOfEmpiresEffect() {
        super(Outcome.Tap);
        this.staticText = "Tap target creature. Gain control of that creature instead if you control artifacts named Scepter of Empires and Throne of Empires";
    }

    private CrownOfEmpiresEffect(CrownOfEmpiresEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        boolean scepter = false;
        boolean throne = false;
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(source.getControllerId())) {
            if (CardUtil.haveSameNames((MageObject)permanent, (String)"Scepter of Empires", (Game)game)) {
                scepter = true;
            } else if (CardUtil.haveSameNames((MageObject)permanent, (String)"Throne of Empires", (Game)game)) {
                throne = true;
            }
            if (!scepter || !throne) continue;
            break;
        }
        if (scepter && throne) {
            CrownOfEmpiresControlEffect effect = new CrownOfEmpiresControlEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(target.getId(), game));
            game.getState().setValue(source.getSourceId().toString(), (Object)source.getControllerId());
            game.addEffect((ContinuousEffect)effect, source);
        } else {
            target.tap(source, game);
        }
        return false;
    }

    public CrownOfEmpiresEffect copy() {
        return new CrownOfEmpiresEffect(this);
    }
}

