/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class CrownOfTheAgesEffect
extends OneShotEffect {
    CrownOfTheAgesEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "attach target Aura attached to a creature to another creature";
    }

    private CrownOfTheAgesEffect(CrownOfTheAgesEffect effect) {
        super((OneShotEffect)effect);
    }

    public CrownOfTheAgesEffect copy() {
        return new CrownOfTheAgesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent aura = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (aura == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent("another creature");
        filter.add(Predicates.not((Predicate)new PermanentIdPredicate(aura.getAttachedTo())));
        if (!game.getBattlefield().contains((FilterPermanent)filter, source, game, 1)) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
        target.withNotTarget(true);
        controller.choose(Outcome.Neutral, (Target)target, source, game);
        return Optional.ofNullable(target).map(Target::getFirstTarget).map(arg_0 -> ((Game)game).getPermanent(arg_0)).map(permanent -> permanent.addAttachment(aura.getId(), source, game)).orElse(false);
    }
}

