/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class CruelRevivalEffect
extends OneShotEffect {
    CruelRevivalEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target non-Zombie creature. It can't be regenerated. Return up to one target Zombie card from your graveyard to your hand";
    }

    private CruelRevivalEffect(CruelRevivalEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetDestroy = game.getPermanent(source.getFirstTarget());
        if (targetDestroy != null) {
            targetDestroy.destroy(source, game, true);
        }
        Player player = game.getPlayer(source.getControllerId());
        Card targetRetrieve = game.getCard(((Target)source.getTargets().get(1)).getFirstTarget());
        if (player != null && targetRetrieve != null) {
            player.moveCards(targetRetrieve, Zone.HAND, source, game);
        }
        return true;
    }

    public CruelRevivalEffect copy() {
        return new CruelRevivalEffect(this);
    }
}

