/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class CrushUnderfootEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent(SubType.GIANT, "Giant creature you control");

    public CrushUnderfootEffect() {
        super(Outcome.Damage);
        this.staticText = "Choose a Giant creature you control. It deals damage equal to its power to target creature";
    }

    private CrushUnderfootEffect(CrushUnderfootEffect effect) {
        super((OneShotEffect)effect);
    }

    public CrushUnderfootEffect copy() {
        return new CrushUnderfootEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(filter);
        target.withNotTarget(true);
        if (!target.canChoose(controller.getId(), source, game) || !controller.chooseTarget(this.outcome, (Target)target, source, game)) {
            return false;
        }
        Permanent giant = game.getPermanent(target.getFirstTarget());
        if (giant == null) {
            return false;
        }
        game.informPlayers("Crush Underfoot: Chosen Giant is " + giant.getName());
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        return targetCreature != null && targetCreature.damage(giant.getPower().getValue(), source.getSourceId(), source, game, false, true) > 0;
    }
}

