/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.GameState;
import mage.players.Player;

class CryptIncursionEffect
extends OneShotEffect {
    CryptIncursionEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile all creature cards from target player's graveyard. You gain 3 life for each card exiled this way";
    }

    private CryptIncursionEffect(CryptIncursionEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        CardsImpl cards = new CardsImpl(targetPlayer.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        int count = cards.stream().map(arg_0 -> ((GameState)game.getState()).getZone(arg_0)).map(arg_0 -> Zone.EXILED.equals(arg_0)).mapToInt(x -> x != false ? 1 : 0).sum();
        player.gainLife(3 * count, game, source);
        return true;
    }

    public CryptIncursionEffect copy() {
        return new CryptIncursionEffect(this);
    }
}

