/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.List;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.keyword.ManifestEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CrypticCoatEffect
extends OneShotEffect {
    CrypticCoatEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "cloak the top card of your library, then attach {this} to it";
    }

    private CrypticCoatEffect(CrypticCoatEffect effect) {
        super((OneShotEffect)effect);
    }

    public CrypticCoatEffect copy() {
        return new CrypticCoatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        List cloakedList = ManifestEffect.doManifestCards((Game)game, (Ability)source, (Player)controller, (Set)controller.getLibrary().getTopCards(game, 1), (boolean)true);
        if (cloakedList.isEmpty()) {
            return false;
        }
        Permanent cloaked = (Permanent)cloakedList.get(0);
        new AttachEffect(Outcome.BoostCreature, "attach {this} to it").setTargetPointer((TargetPointer)new FixedTarget(cloaked, game)).apply(game, source);
        return true;
    }
}

