/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;
import mage.util.functions.CopyApplier;

class CryptoplasmEffect
extends OneShotEffect {
    CryptoplasmEffect() {
        super(Outcome.Copy);
        this.staticText = "you may have {this} become a copy of another target creature, except it has this ability";
    }

    private CryptoplasmEffect(CryptoplasmEffect effect) {
        super((OneShotEffect)effect);
    }

    public CryptoplasmEffect copy() {
        return new CryptoplasmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creatureToCopy = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creatureToCopy != null) {
            CopyApplier applier = new CopyApplier(){

                public boolean apply(Game game, MageObject blueprint, Ability source, UUID copyToObjectId) {
                    BeginningOfUpkeepTriggeredAbility upkeepAbility = new BeginningOfUpkeepTriggeredAbility((Effect)new CryptoplasmEffect(), true);
                    upkeepAbility.addTarget((Target)new TargetCreaturePermanent());
                    blueprint.getAbilities().add((Object)upkeepAbility);
                    return true;
                }
            };
            game.copyPermanent(creatureToCopy, source.getSourceId(), source, applier);
        }
        return true;
    }
}

