/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.EnumSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.RandomUtil;

class CrystallineGiantEffect
extends OneShotEffect {
    private static final EnumSet<CounterType> counterTypeSet = EnumSet.noneOf(CounterType.class);

    CrystallineGiantEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a kind of counter at random that {this} doesn't have on it from among flying, first strike, deathtouch, hexproof, lifelink, menace, reach, trample, vigilance, and +1/+1. Put a counter of that kind on {this}";
    }

    private CrystallineGiantEffect(CrystallineGiantEffect effect) {
        super((OneShotEffect)effect);
    }

    public CrystallineGiantEffect copy() {
        return new CrystallineGiantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        Counters counters = permanent.getCounters(game);
        ArrayList<CounterType> counterTypes = new ArrayList<CounterType>();
        counterTypes.addAll(counterTypeSet);
        counterTypes.removeIf(arg_0 -> ((Counters)counters).containsKey(arg_0));
        if (counterTypes.isEmpty()) {
            return true;
        }
        return permanent.addCounters(((CounterType)counterTypes.get(RandomUtil.nextInt((int)counterTypes.size()))).createInstance(), source.getControllerId(), source, game);
    }

    static {
        counterTypeSet.add(CounterType.FLYING);
        counterTypeSet.add(CounterType.FIRST_STRIKE);
        counterTypeSet.add(CounterType.DEATHTOUCH);
        counterTypeSet.add(CounterType.HEXPROOF);
        counterTypeSet.add(CounterType.LIFELINK);
        counterTypeSet.add(CounterType.MENACE);
        counterTypeSet.add(CounterType.REACH);
        counterTypeSet.add(CounterType.TRAMPLE);
        counterTypeSet.add(CounterType.VIGILANCE);
        counterTypeSet.add(CounterType.P1P1);
    }
}

