/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.UUID;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class CultConscriptWatcher
extends Watcher {
    private final HashSet<UUID> playerSet = new HashSet();

    public CultConscriptWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Permanent permanent;
        ZoneChangeEvent zEvent;
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && (zEvent = (ZoneChangeEvent)event).isDiesEvent() && (permanent = zEvent.getTarget()) != null && permanent.isCreature(game) && !permanent.hasSubtype(SubType.SKELETON, game)) {
            this.playerSet.add(permanent.getControllerId());
        }
    }

    public void reset() {
        super.reset();
        this.playerSet.clear();
    }

    public boolean nonSkeletonDied(UUID playerId) {
        return this.playerSet.contains(playerId);
    }
}

