/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.cards.c.CunningAbductionSpendAnyManaEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class CunningAbductionExileEffect
extends OneShotEffect {
    private static final FilterNonlandCard filter = new FilterNonlandCard();

    public CunningAbductionExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent reveals their hand. You choose a nonland card from that player's hand and exile it. You may cast that card for as long as it remains exiled, and you may spend mana as though it were mana of any color to cast that spell";
    }

    private CunningAbductionExileEffect(CunningAbductionExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public CunningAbductionExileEffect copy() {
        return new CunningAbductionExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = game.getObject(source);
        if (opponent != null && sourceObject != null) {
            opponent.revealCards(sourceObject.getName(), opponent.getHand(), game);
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null) {
                int cardsHand = opponent.getHand().count((FilterCard)filter, game);
                Card card = null;
                if (cardsHand > 0) {
                    TargetCard target = new TargetCard(Zone.HAND, (FilterCard)filter);
                    if (controller.choose(Outcome.Benefit, opponent.getHand(), target, source, game)) {
                        card = opponent.getHand().get(target.getFirstTarget(), game);
                    }
                }
                if (card != null) {
                    UUID exileId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
                    controller.moveCardsToExile(card, source, game, true, exileId, sourceObject.getIdName());
                    Object effect = new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, Duration.Custom);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
                    game.addEffect((ContinuousEffect)effect, source);
                    effect = new CunningAbductionSpendAnyManaEffect();
                    effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
                return true;
            }
        }
        return false;
    }
}

