/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class CunningRhetoricEffect
extends OneShotEffect {
    CunningRhetoricEffect() {
        super(Outcome.Benefit);
    }

    private CunningRhetoricEffect(CunningRhetoricEffect effect) {
        super((OneShotEffect)effect);
    }

    public CunningRhetoricEffect copy() {
        return new CunningRhetoricEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = source.getSourceObject(game);
        if (opponent == null || sourceObject == null) {
            return false;
        }
        Card card = opponent.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (UUID)sourceObject.getId(), (int)sourceObject.getZoneChangeCounter(game));
        opponent.moveCardsToExile(card, source, game, true, exileZoneId, sourceObject.getIdName());
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.Custom, (boolean)true);
        return true;
    }
}

