/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.c.CunningRhetoricEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CunningRhetoricTriggeredAbility
extends TriggeredAbilityImpl {
    public CunningRhetoricTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CunningRhetoricEffect(), false);
    }

    private CunningRhetoricTriggeredAbility(CunningRhetoricTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CunningRhetoricTriggeredAbility copy() {
        return new CunningRhetoricTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        UUID playerId = game.getCombat().getAttackers().stream().filter(attacker -> this.isControlledBy(game.getCombat().getDefendingPlayerId(attacker, game))).map(arg_0 -> ((Game)game).getControllerId(arg_0)).filter(game.getOpponents(this.getControllerId())::contains).findFirst().orElse(null);
        if (playerId == null) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(playerId));
        return true;
    }

    public String getRule() {
        return "Whenever an opponent attacks you and/or one or more planeswalkers you control, exile the top card of that player's library. You may play that card for as long as it remains exiled, and you may spend mana as though it were mana of any color to cast it.";
    }
}

