/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class CuratorsWardTriggeredAbility
extends TriggeredAbilityImpl {
    public CuratorsWardTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(2), false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private CuratorsWardTriggeredAbility(CuratorsWardTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchanted;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.getFromZone() == Zone.BATTLEFIELD && (enchanted = game.getPermanentOrLKIBattlefield(event.getTargetId())) != null && enchanted.getAttachments().contains(this.getSourceId()) && enchanted.isHistoric(game);
    }

    public String getRule() {
        return "When enchanted permanent leaves the battlefield, if it was historic, draw two cards. <i>(Artifacts, legendaries, and Sagas are historic.)</i>";
    }

    public CuratorsWardTriggeredAbility copy() {
        return new CuratorsWardTriggeredAbility(this);
    }
}

