/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Iterator;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.common.DealsCombatDamageToAPlayerTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileTargetCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.cards.c.CurieEmergentIntelligenceValue;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;

class CurieEmergentIntelligenceCopyEffect
extends OneShotEffect {
    private static final CopyApplier applier = new CopyApplier(){

        public boolean apply(Game game, MageObject blueprint, Ability source, UUID targetObjectId) {
            blueprint.getAbilities().add((Object)new DealsCombatDamageToAPlayerTriggeredAbility((Effect)new DrawCardSourceControllerEffect((DynamicValue)CurieEmergentIntelligenceValue.NON_NEGATIVE).setText("draw cards equal to its base power"), false));
            return true;
        }
    };

    CurieEmergentIntelligenceCopyEffect() {
        super(Outcome.Benefit);
        this.setText("{this} becomes a copy of the exiled creature, except it has \"Whenever this creature deals combat damage to a player, draw cards equal to its base power.\"");
    }

    private CurieEmergentIntelligenceCopyEffect(CurieEmergentIntelligenceCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public CurieEmergentIntelligenceCopyEffect copy() {
        return new CurieEmergentIntelligenceCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Cost c : source.getCosts()) {
            Iterator iterator;
            if (!c.isPaid() || !(c instanceof ExileTargetCost) || !(iterator = ((ExileTargetCost)c).getPermanents().iterator()).hasNext()) continue;
            Permanent exiled = (Permanent)iterator.next();
            if (exiled != null) {
                game.copyPermanent(Duration.WhileOnBattlefield, exiled, source.getSourceId(), source, applier);
                return true;
            }
            return false;
        }
        return false;
    }
}

