/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.BeastToken;
import mage.game.permanent.token.Token;

class CuriousHerdEffect
extends OneShotEffect {
    private static final Token token = new BeastToken();

    CuriousHerdEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose target opponent. You create X 3/3 green Beast creature tokens, where X is the number of artifacts that player controls.";
    }

    private CuriousHerdEffect(CuriousHerdEffect effect) {
        super((OneShotEffect)effect);
    }

    public CuriousHerdEffect copy() {
        return new CuriousHerdEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int artifactCount = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_ARTIFACT, source.getFirstTarget(), game);
        if (artifactCount > 0) {
            token.putOntoBattlefield(artifactCount, game, source, source.getControllerId());
        }
        return true;
    }
}

