/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class CurrencyConverterExileEffect
extends OneShotEffect {
    CurrencyConverterExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile that card from your graveyard";
    }

    private CurrencyConverterExileEffect(CurrencyConverterExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public CurrencyConverterExileEffect copy() {
        return new CurrencyConverterExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = (Card)this.getValue("discardedCard");
        if (player == null || card == null || !card.isOwnedBy(player.getId()) || !Zone.GRAVEYARD.match(game.getState().getZone(card.getId()))) {
            return false;
        }
        return player.moveCardsToExile(card, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
    }
}

