/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class CurseOfChaosEffect
extends OneShotEffect {
    CurseOfChaosEffect() {
        super(Outcome.Benefit);
        this.staticText = "that attacking player may discard a card. If the player does, they draw a card";
    }

    private CurseOfChaosEffect(CurseOfChaosEffect effect) {
        super((OneShotEffect)effect);
    }

    public CurseOfChaosEffect copy() {
        return new CurseOfChaosEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player attacker = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (attacker != null) {
            if (!attacker.getHand().isEmpty() && attacker.chooseUse(this.outcome, "Discard a card and draw a card?", source, game)) {
                attacker.discard(1, false, false, source, game);
                attacker.drawCards(1, source, game);
            }
            return true;
        }
        return false;
    }
}

