/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CurseOfFoolsWisdomTriggeredAbility
extends TriggeredAbilityImpl {
    CurseOfFoolsWisdomTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private CurseOfFoolsWisdomTriggeredAbility(CurseOfFoolsWisdomTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DREW_CARD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantment = game.getPermanentOrLKIBattlefield(this.getSourceId());
        if (enchantment == null || !event.getPlayerId().equals(enchantment.getAttachedTo())) {
            return false;
        }
        this.getEffects().clear();
        LoseLifeTargetEffect effect = new LoseLifeTargetEffect(2);
        effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId(), game));
        this.addEffect((Effect)effect);
        this.addEffect((Effect)new GainLifeEffect(2));
        return true;
    }

    public String getRule() {
        return "Whenever enchanted player draws a card, they lose 2 life and you gain 2 life.";
    }

    public CurseOfFoolsWisdomTriggeredAbility copy() {
        return new CurseOfFoolsWisdomTriggeredAbility(this);
    }
}

