/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.c.CurseOfInertiaTapOrUntapTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetadjustment.DefineByTriggerTargetAdjuster;
import mage.target.targetadjustment.TargetAdjuster;

class CurseOfInertiaTriggeredAbility
extends TriggeredAbilityImpl {
    public CurseOfInertiaTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CurseOfInertiaTapOrUntapTargetEffect(), false);
        this.setTargetAdjuster((TargetAdjuster)DefineByTriggerTargetAdjuster.instance);
    }

    private CurseOfInertiaTriggeredAbility(CurseOfInertiaTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantment = game.getPermanent(this.getSourceId());
        if (enchantment != null && enchantment.getAttachedTo() != null && game.getCombat().getPlayerDefenders(game, false).contains(enchantment.getAttachedTo())) {
            TargetPermanent target = new TargetPermanent();
            target.setTargetController(game.getCombat().getAttackingPlayerId());
            this.getTargets().clear();
            this.addTarget((Target)target);
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a player attacks enchanted player with one or more creatures, that attacking player may tap or untap target permanent of their choice.";
    }

    public CurseOfInertiaTriggeredAbility copy() {
        return new CurseOfInertiaTriggeredAbility(this);
    }
}

