/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class CurseOfTheCabalSacrificeEffect
extends OneShotEffect {
    CurseOfTheCabalSacrificeEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Target player sacrifices half the permanents they control of their choice, rounded down.";
    }

    private CurseOfTheCabalSacrificeEffect(CurseOfTheCabalSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public CurseOfTheCabalSacrificeEffect copy() {
        return new CurseOfTheCabalSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (targetPlayer != null) {
            int amount = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT, targetPlayer.getId(), game) / 2;
            if (amount < 1) {
                return true;
            }
            TargetSacrifice target = new TargetSacrifice(amount, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT);
            if (target.canChoose(targetPlayer.getId(), source, game)) {
                while (!target.isChosen(game) && target.canChoose(targetPlayer.getId(), source, game) && targetPlayer.canRespond()) {
                    targetPlayer.choose(Outcome.Sacrifice, (Target)target, source, game);
                }
                target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).forEach(permanent -> permanent.sacrifice(source, game));
            }
            return true;
        }
        return false;
    }
}

