/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterPlaneswalkerPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class CurseOfThePiercedHeartEffect
extends OneShotEffect {
    CurseOfThePiercedHeartEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 1 damage to that player or a planeswalker that player controls";
    }

    private CurseOfThePiercedHeartEffect(CurseOfThePiercedHeartEffect effect) {
        super((OneShotEffect)effect);
    }

    public CurseOfThePiercedHeartEffect copy() {
        return new CurseOfThePiercedHeartEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        if (game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_PLANESWALKER, opponent.getId(), source, game) < 1 || !controller.chooseUse(Outcome.Damage, "Redirect to a planeswalker controlled by " + opponent.getLogName() + "?", source, game)) {
            return opponent.damage(1, source.getSourceId(), source, game) > 0;
        }
        FilterPlaneswalkerPermanent filter = new FilterPlaneswalkerPermanent("a planeswalker controlled by " + opponent.getLogName());
        filter.add((Predicate)new ControllerIdPredicate(opponent.getId()));
        TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
        target.withNotTarget(true);
        controller.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent != null) {
            return permanent.damage(1, source.getSourceId(), source, game, false, true) > 0;
        }
        return opponent.damage(1, source.getSourceId(), source, game) > 0;
    }
}

