/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.Boar2Token;
import mage.players.Player;

class CurseOfTheSwineEffect
extends OneShotEffect {
    CurseOfTheSwineEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile X target creatures. For each creature exiled this way, its controller creates a 2/2 green Boar creature token";
    }

    private CurseOfTheSwineEffect(CurseOfTheSwineEffect effect) {
        super((OneShotEffect)effect);
    }

    public CurseOfTheSwineEffect copy() {
        return new CurseOfTheSwineEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        CardsImpl creaturesToExile = new CardsImpl();
        if (controller != null) {
            HashMap<UUID, Integer> playersWithTargets = new HashMap<UUID, Integer>();
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                Permanent creature = game.getPermanent(targetId);
                if (creature instanceof PermanentToken) {
                    playersWithTargets.put(creature.getControllerId(), playersWithTargets.getOrDefault(creature.getControllerId(), 0) + 1);
                }
                if (creature == null) continue;
                creaturesToExile.add((Card)creature);
            }
            controller.moveCards((Cards)creaturesToExile, Zone.EXILED, source, game);
            for (Card card : creaturesToExile.getCards(game)) {
                Permanent lkiP = game.getPermanentOrLKIBattlefield(card.getId());
                if (lkiP == null || game.getState().getZone(lkiP.getId()) != Zone.EXILED) continue;
                playersWithTargets.put(lkiP.getControllerId(), playersWithTargets.getOrDefault(lkiP.getControllerId(), 0) + 1);
            }
            game.processAction();
            Boar2Token swineToken = new Boar2Token();
            for (Map.Entry exiledByController : playersWithTargets.entrySet()) {
                swineToken.putOntoBattlefield(((Integer)exiledByController.getValue()).intValue(), game, source, (UUID)exiledByController.getKey());
            }
            return true;
        }
        return false;
    }
}

