/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.c.CurseOfTheWerefoxFightEffect;
import mage.constants.Outcome;
import mage.constants.RoleType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CurseOfTheWerefoxEffect
extends OneShotEffect {
    CurseOfTheWerefoxEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a Monster Role token attached to target creature you control. When you do, that creature fights up to one target creature you don't control";
    }

    private CurseOfTheWerefoxEffect(CurseOfTheWerefoxEffect effect) {
        super((OneShotEffect)effect);
    }

    public CurseOfTheWerefoxEffect copy() {
        return new CurseOfTheWerefoxEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getFirstTarget());
        if (target == null || RoleType.MONSTER.createToken(target, game, source).getLastAddedTokenIds().isEmpty()) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new CurseOfTheWerefoxFightEffect().setTargetPointer((TargetPointer)new FixedTarget(target.getId(), game)), false, "that creature fights up to one target creature you don't control");
        ability.addTarget((Target)new TargetPermanent(0, 1, (FilterPermanent)StaticFilters.FILTER_CREATURE_YOU_DONT_CONTROL));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

