/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CurseOfVengeanceDrawLifeEffect
extends OneShotEffect {
    CurseOfVengeanceDrawLifeEffect() {
        super(Outcome.Benefit);
        this.staticText = "you gain X life and draw X cards, where X is the number of spite counters on {this}";
    }

    private CurseOfVengeanceDrawLifeEffect(CurseOfVengeanceDrawLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public CurseOfVengeanceDrawLifeEffect copy() {
        return new CurseOfVengeanceDrawLifeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourceObject = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourceObject != null && controller != null) {
            if (sourceObject.getCounters(game).containsKey(CounterType.SPITE)) {
                controller.drawCards(sourceObject.getCounters(game).getCount(CounterType.SPITE), source, game);
                controller.gainLife(sourceObject.getCounters(game).getCount(CounterType.SPITE), game, source);
            }
            return true;
        }
        return false;
    }
}

