/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.c.GiveControlEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class CustodyBattleUnlessPaysEffect
extends OneShotEffect {
    protected Cost cost;

    CustodyBattleUnlessPaysEffect(Cost cost) {
        super(Outcome.Sacrifice);
        this.staticText = "target opponent gains control of {this} unless you sacrifice a land";
        this.cost = cost;
    }

    private CustodyBattleUnlessPaysEffect(CustodyBattleUnlessPaysEffect effect) {
        super((OneShotEffect)effect);
        this.cost = effect.cost.copy();
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourcePermanent != null) {
            String message = "sacrifice a land?";
            message = CardUtil.replaceSourceName((String)message, (String)sourcePermanent.getLogName());
            message = Character.toUpperCase(message.charAt(0)) + message.substring(1);
            if (this.cost.canPay(source, source, source.getControllerId(), game) && controller.chooseUse(Outcome.Benefit, message, source, game)) {
                this.cost.clearPaid();
                if (this.cost.pay(source, game, source, source.getControllerId(), false, null)) {
                    return true;
                }
            }
            if (source.getStackMomentSourceZCC() == game.getState().getZoneChangeCounter(source.getSourceId()) && game.getState().getZone(source.getSourceId()) == Zone.BATTLEFIELD) {
                GiveControlEffect effect = new GiveControlEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
                game.addEffect((ContinuousEffect)effect, source);
                game.informPlayers(game.getPlayer(source.getFirstTarget()).getLogName() + " gains control of " + sourcePermanent.getIdName());
            }
            return true;
        }
        return false;
    }

    public CustodyBattleUnlessPaysEffect copy() {
        return new CustodyBattleUnlessPaysEffect(this);
    }
}

