/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class CutShortWatcher
extends Watcher {
    private final Set<MageObjectReference> set = new HashSet<MageObjectReference>();

    CutShortWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ACTIVATED_ABILITY) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent != null) {
            this.set.add(new MageObjectReference((MageObject)permanent, game));
        }
    }

    public void reset() {
        super.reset();
        this.set.clear();
    }

    static boolean checkPermanent(Permanent permanent, Game game) {
        return ((CutShortWatcher)game.getState().getWatcher(CutShortWatcher.class)).set.contains(new MageObjectReference((MageObject)permanent, game));
    }
}

