/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.ManaUtil;

class CutTheTethersEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent(SubType.SPIRIT, "");

    CutTheTethersEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "For each Spirit, return it to its owner's hand unless that player pays {3}";
    }

    private CutTheTethersEffect(CutTheTethersEffect effect) {
        super((OneShotEffect)effect);
    }

    public CutTheTethersEffect copy() {
        return new CutTheTethersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl toHand = new CardsImpl();
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            Player player = game.getPlayer(permanent.getOwnerId());
            if (player == null) continue;
            boolean paid = false;
            if (player.chooseUse(Outcome.Benefit, "Pay {3} to keep " + permanent.getIdName() + " on the battlefield?", source, game)) {
                ManaCost cost = ManaUtil.createManaCost((int)3, (boolean)false);
                paid = cost.pay(source, game, source, permanent.getControllerId(), false, null);
            }
            if (paid) continue;
            toHand.add((Card)permanent);
        }
        controller.moveCards((Cards)toHand, Zone.HAND, source, game);
        return true;
    }
}

