/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.RemoveAllCountersPermanentTargetEffect;
import mage.cards.c.CyclopeanTombCounterWatcher;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CyclopeanTombEffect
extends OneShotEffect {
    CyclopeanTombEffect() {
        super(Outcome.Benefit);
        this.staticText = "At the beginning of each of your upkeeps for the rest of the game, remove all mire counters from a land that a mire counter was put onto with {this} but that a mire counter has not been removed from with {this}";
    }

    private CyclopeanTombEffect(CyclopeanTombEffect effect) {
        super((OneShotEffect)effect);
    }

    public CyclopeanTombEffect copy() {
        return new CyclopeanTombEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObjectReference mor = new MageObjectReference(source.getSourceId(), source.getStackMomentSourceZCC(), game);
        CyclopeanTombCounterWatcher watcher = (CyclopeanTombCounterWatcher)game.getState().getWatcher(CyclopeanTombCounterWatcher.class);
        if (controller != null && watcher != null) {
            Permanent chosenLand;
            Set<MageObjectReference> landRef = watcher.landMiredByCyclopeanTombInstance(mor, game);
            if (landRef == null || landRef.isEmpty()) {
                return true;
            }
            FilterLandPermanent filter = new FilterLandPermanent("a land with a mire counter added from the Cyclopean Tomb instance (" + landRef.size() + " left)");
            HashSet<PermanentIdPredicate> idPref = new HashSet<PermanentIdPredicate>();
            for (MageObjectReference ref : landRef) {
                Permanent land = ref.getPermanent(game);
                if (land == null) continue;
                idPref.add(new PermanentIdPredicate(land.getId()));
            }
            filter.add(Predicates.or(idPref));
            TargetPermanent target = new TargetPermanent(1, 1, (FilterPermanent)filter, true);
            if (controller.chooseTarget(Outcome.Neutral, (Target)target, source, game) && (chosenLand = game.getPermanent(target.getFirstTarget())) != null) {
                RemoveAllCountersPermanentTargetEffect effect = new RemoveAllCountersPermanentTargetEffect(CounterType.MIRE);
                effect.setTargetPointer((TargetPointer)new FixedTarget(chosenLand, game));
                effect.apply(game, source);
                landRef.remove(new MageObjectReference((MageObject)chosenLand, game));
            }
            return true;
        }
        return false;
    }
}

