/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class CytoshapeEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("nonlegendary creature");

    CytoshapeEffect() {
        super(Outcome.Copy);
        this.staticText = "Choose a nonlegendary creature on the battlefield. Target creature becomes a copy of that creature until end of turn.";
    }

    private CytoshapeEffect(CytoshapeEffect effect) {
        super((OneShotEffect)effect);
    }

    public CytoshapeEffect copy() {
        return new CytoshapeEffect(this);
    }

    public boolean apply(Game game, Ability ability) {
        Permanent copyTo;
        TargetPermanent target = new TargetPermanent(1, 1, (FilterPermanent)filter, true);
        target.choose(Outcome.Copy, ability.getControllerId(), ability, game);
        Permanent copyFrom = game.getPermanent(target.getFirstTarget());
        if (copyFrom != null && (copyTo = game.getPermanentOrLKIBattlefield(((Target)ability.getTargets().get(0)).getFirstTarget())) != null) {
            game.copyPermanent(Duration.EndOfTurn, copyFrom, copyTo.getId(), ability, (CopyApplier)new EmptyCopyApplier());
        }
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)SuperType.LEGENDARY.getPredicate()));
    }
}

