/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;

class TheOmenkeelPlayFromExileEffect
extends AsThoughEffectImpl {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    TheOmenkeelPlayFromExileEffect(Cards cards, Game game) {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.morSet.addAll(cards.stream().map(uuid -> new MageObjectReference(uuid, game)).collect(Collectors.toSet()));
    }

    private TheOmenkeelPlayFromExileEffect(TheOmenkeelPlayFromExileEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.morSet.addAll(effect.morSet);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public TheOmenkeelPlayFromExileEffect copy() {
        return new TheOmenkeelPlayFromExileEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.isControlledBy(affectedControllerId) || game.getState().getZone(sourceId) != Zone.EXILED) {
            return false;
        }
        Card card = game.getCard(sourceId);
        return card != null && card.isLand(game) && this.morSet.stream().anyMatch(mor -> mor.refersTo((MageObject)card, game));
    }
}

