/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesColorTargetEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BecomesColorOrColorsEnchantedEffect
extends OneShotEffect {
    BecomesColorOrColorsEnchantedEffect() {
        super(Outcome.Neutral);
        this.staticText = "Enchanted creature becomes the color or colors of your choice";
    }

    private BecomesColorOrColorsEnchantedEffect(BecomesColorOrColorsEnchantedEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent enchantment = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (enchantment == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(enchantment.getAttachedTo());
        StringBuilder sb = new StringBuilder();
        if (controller == null || permanent == null) {
            return false;
        }
        for (int i = 0; i < 5 && (i <= 0 || controller.chooseUse(Outcome.Neutral, "Choose another color?", source, game)); ++i) {
            ChoiceColor choiceColor = new ChoiceColor();
            if (!controller.choose(Outcome.Benefit, (Choice)choiceColor, game)) {
                return false;
            }
            if (!game.isSimulation()) {
                game.informPlayers(permanent.getName() + ": " + controller.getLogName() + " has chosen " + choiceColor.getChoice());
            }
            if (choiceColor.getColor().isBlack()) {
                sb.append('B');
                continue;
            }
            if (choiceColor.getColor().isBlue()) {
                sb.append('U');
                continue;
            }
            if (choiceColor.getColor().isRed()) {
                sb.append('R');
                continue;
            }
            if (choiceColor.getColor().isGreen()) {
                sb.append('G');
                continue;
            }
            if (!choiceColor.getColor().isWhite()) continue;
            sb.append('W');
        }
        String colors = new String(sb);
        ObjectColor chosenColors = new ObjectColor(colors);
        BecomesColorTargetEffect effect = new BecomesColorTargetEffect(chosenColors, Duration.Custom);
        effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }

    public BecomesColorOrColorsEnchantedEffect copy() {
        return new BecomesColorOrColorsEnchantedEffect(this);
    }
}

