/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CardPutIntoOpponentGraveThisTurn
extends DelayedTriggeredAbility {
    public CardPutIntoOpponentGraveThisTurn() {
        super((Effect)new LoseLifeTargetEffect(1), Duration.EndOfTurn, false);
    }

    private CardPutIntoOpponentGraveThisTurn(CardPutIntoOpponentGraveThisTurn ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public CardPutIntoOpponentGraveThisTurn copy() {
        return new CardPutIntoOpponentGraveThisTurn(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        UUID cardId = event.getTargetId();
        Card card = game.getCard(cardId);
        if (card != null && zEvent.getToZone() == Zone.GRAVEYARD && !card.isCopy() && game.getOpponents(this.controllerId).contains(card.getOwnerId())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(card.getOwnerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a card is put into an opponent's graveyard from anywhere this turn, that player loses 1 life";
    }
}

