/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardAllEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class DakraMysticEffect
extends OneShotEffect {
    DakraMysticEffect() {
        super(Outcome.Detriment);
        this.staticText = "Each player reveals the top card of their library. You may put the revealed cards into their owners' graveyard. If you don't, each player draws a card";
    }

    private DakraMysticEffect(DakraMysticEffect effect) {
        super((OneShotEffect)effect);
    }

    public DakraMysticEffect copy() {
        return new DakraMysticEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player;
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null || !player.getLibrary().hasCards()) continue;
                player.revealCards(player.getLogName(), (Cards)new CardsImpl(player.getLibrary().getFromTop(game)), game);
            }
            if (controller.chooseUse(this.outcome, "Put revealed cards into graveyard?", source, game)) {
                for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                    player = game.getPlayer(playerId);
                    if (player == null || !player.getLibrary().hasCards()) continue;
                    player.moveCards(player.getLibrary().getFromTop(game), Zone.GRAVEYARD, source, game);
                }
            } else {
                new DrawCardAllEffect(1).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

