/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class DamnablePactEffect
extends OneShotEffect {
    DamnablePactEffect() {
        super(Outcome.Neutral);
        this.staticText = "Target player draws X cards and loses X life";
    }

    private DamnablePactEffect(DamnablePactEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer != null) {
            targetPlayer.drawCards(((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue(), source, game);
            targetPlayer.loseLife(((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue(), game, source, false);
            return true;
        }
        return false;
    }

    public DamnablePactEffect copy() {
        return new DamnablePactEffect(this);
    }
}

