/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.d.DampingEngineEffect;
import mage.cards.d.DampingEngineSpecialAction;
import mage.constants.CardType;
import mage.game.Controllable;
import mage.game.Game;
import mage.players.Player;

public class DampingEngine
extends CardImpl {
    public DampingEngine(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{4}");
        SimpleStaticAbility ability = new SimpleStaticAbility((Effect)new DampingEngineEffect());
        ability.addEffect((Effect)new GainAbilitySourceEffect((Ability)new DampingEngineSpecialAction()).setText("That player may sacrifice a permanent for that player to ignore this effect until end of turn"));
        this.addAbility((Ability)ability);
    }

    private DampingEngine(DampingEngine card) {
        super((CardImpl)card);
    }

    public DampingEngine copy() {
        return new DampingEngine(this);
    }

    static boolean checkPlayer(Player player, Game game) {
        int otherPerms;
        Map map = game.getBattlefield().getActivePermanents(player.getId(), game).stream().filter(Objects::nonNull).map(Controllable::getControllerId).collect(Collectors.toMap(Function.identity(), x -> 1, Integer::sum));
        int playerPerms = map.getOrDefault(player.getId(), 0);
        return playerPerms > (otherPerms = map.entrySet().stream().filter(e -> !player.getId().equals(e.getKey())).mapToInt(e -> (Integer)e.getValue()).max().orElse(0));
    }

    static String makeKey(UUID playerId, Ability source, Game game) {
        return "dampingEngine_" + playerId + "_" + source.getSourceId() + "_" + source.getStackMomentSourceZCC() + "_" + game.getTurnNum();
    }

    static boolean checkValue(UUID playerId, Ability source, Game game) {
        Object object = game.getState().getValue(DampingEngine.makeKey(playerId, source, game));
        return object instanceof Boolean && (Boolean)object != false;
    }
}

