/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;

class DampingSphereReplacementEffect
extends ReplacementEffectImpl {
    DampingSphereReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "If a land is tapped for two or more mana, it produces {C} instead of any other type and amount";
    }

    private DampingSphereReplacementEffect(DampingSphereReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public DampingSphereReplacementEffect copy() {
        return new DampingSphereReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ManaEvent manaEvent = (ManaEvent)event;
        Mana mana = manaEvent.getMana();
        mana.setToMana(Mana.ColorlessMana((int)1));
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        TappedForManaEvent manaEvent = (TappedForManaEvent)event;
        Permanent land = manaEvent.getPermanent();
        Mana mana = manaEvent.getMana();
        return land != null && land.isLand(game) && mana.count() > 1;
    }
}

