/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.card.AuraCardCanAttachToPermanentId;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;

class DanithaBenaliasHopeEffect
extends OneShotEffect {
    DanithaBenaliasHopeEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "you may put an Aura or Equipment card from your hand or graveyard onto the battlefield attached to {this}";
    }

    private DanithaBenaliasHopeEffect(DanithaBenaliasHopeEffect effect) {
        super((OneShotEffect)effect);
    }

    public DanithaBenaliasHopeEffect copy() {
        return new DanithaBenaliasHopeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        UUID sourcePermanentId = sourcePermanent == null ? null : sourcePermanent.getId();
        String sourcePermanentName = sourcePermanent == null ? "" : sourcePermanent.getName();
        FilterCard filter = new FilterCard("an Aura or Equipment card");
        filter.add(Predicates.or((Predicate)Predicates.and((Predicate)SubType.AURA.getPredicate(), (Predicate)new AuraCardCanAttachToPermanentId(sourcePermanentId)), (Predicate)SubType.EQUIPMENT.getPredicate()));
        CardsImpl cards = new CardsImpl();
        cards.addAllCards((Collection)controller.getHand().getCards(filter, source.getControllerId(), source, game));
        cards.addAllCards((Collection)controller.getGraveyard().getCards(filter, source.getControllerId(), source, game));
        if (cards.isEmpty()) {
            return true;
        }
        TargetCard target = new TargetCard(0, 1, Zone.ALL, filter);
        target.withNotTarget(true);
        target.withChooseHint("to attach to " + sourcePermanentName);
        controller.choose(this.outcome, (Cards)cards, target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            if (sourcePermanent != null) {
                game.getState().setValue("attachTo:" + card.getId(), (Object)sourcePermanent);
            }
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            if (sourcePermanent != null) {
                sourcePermanent.addAttachment(card.getId(), source, game);
            }
        }
        return true;
    }
}

