/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class DargoTheShipwreckerWatcher
extends Watcher {
    private static final Map<UUID, Integer> sacMap = new HashMap<UUID, Integer>();

    DargoTheShipwreckerWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SACRIFICED_PERMANENT) {
            return;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent != null && (permanent.isCreature(game) || permanent.isArtifact(game))) {
            sacMap.compute(event.getPlayerId(), CardUtil::setOrIncrementValue);
        }
    }

    public void reset() {
        sacMap.clear();
        super.reset();
    }

    int getSacCount(UUID playerId) {
        return sacMap.getOrDefault(playerId, 0);
    }
}

