/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.RemoveCounterSourceEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class DarigaazReincarnatedReturnEffect
extends OneShotEffect {
    DarigaazReincarnatedReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "remove an egg counter from it. Then if this card has no egg counters on it, return it to the battlefield";
    }

    private DarigaazReincarnatedReturnEffect(DarigaazReincarnatedReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public DarigaazReincarnatedReturnEffect copy() {
        return new DarigaazReincarnatedReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = source.getSourceCardIfItStillExists(game);
        if (controller == null || card == null) {
            return false;
        }
        new RemoveCounterSourceEffect(CounterType.EGG.createInstance()).apply(game, source);
        if (card.getCounters(game).getCount(CounterType.EGG) == 0) {
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        return true;
    }
}

