/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.condition.common.SpellMasteryCondition;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.RegenerateTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DarkDabblingEffect
extends OneShotEffect {
    DarkDabblingEffect() {
        super(Outcome.Benefit);
        this.staticText = "<br><i>Spell mastery</i> &mdash; If there are two or more instant and/or sorcery cards in your graveyard, also regenerate each other creature you control";
    }

    private DarkDabblingEffect(DarkDabblingEffect effect) {
        super((OneShotEffect)effect);
    }

    public DarkDabblingEffect copy() {
        return new DarkDabblingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (SpellMasteryCondition.instance.apply(game, source)) {
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game)) {
                if (permanent.getId().equals(this.getTargetPointer().getFirst(game, source))) continue;
                RegenerateTargetEffect regenEffect = new RegenerateTargetEffect();
                regenEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                game.addEffect((ContinuousEffect)regenEffect, source);
            }
        }
        return true;
    }
}

