/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class DarkDealEffect
extends OneShotEffect {
    DarkDealEffect() {
        super(Outcome.Detriment);
        this.staticText = "Each player discards all the cards in their hand, then draws that many cards minus one";
    }

    private DarkDealEffect(DarkDealEffect effect) {
        super((OneShotEffect)effect);
    }

    public DarkDealEffect copy() {
        return new DarkDealEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player;
            LinkedHashMap<UUID, Integer> cardsToDraw = new LinkedHashMap<UUID, Integer>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                int cardsInHand;
                player = game.getPlayer(playerId);
                if (player == null || (cardsInHand = player.getHand().size()) <= 0) continue;
                player.discard(cardsInHand, false, false, source, game);
                cardsToDraw.put(playerId, cardsInHand - 1);
            }
            for (Map.Entry toDrawByPlayer : cardsToDraw.entrySet()) {
                player = game.getPlayer((UUID)toDrawByPlayer.getKey());
                if (player == null || (Integer)toDrawByPlayer.getValue() <= 0) continue;
                player.drawCards(((Integer)toDrawByPlayer.getValue()).intValue(), source, game);
            }
            return true;
        }
        return false;
    }
}

