/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.StateTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.d.DarkDepthsSacrificeEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class DarkDepthsAbility
extends StateTriggeredAbility {
    public DarkDepthsAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DarkDepthsSacrificeEffect());
    }

    private DarkDepthsAbility(DarkDepthsAbility ability) {
        super((StateTriggeredAbility)ability);
    }

    public DarkDepthsAbility copy() {
        return new DarkDepthsAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(this.getSourceId());
        return permanent != null && permanent.getCounters(game).getCount(CounterType.ICE) == 0;
    }

    public String getRule() {
        return "When {this} has no ice counters on it, sacrifice it. If you do, create Marit Lage, a legendary 20/20 black Avatar creature token with flying and indestructible.";
    }
}

