/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class DarkSuspicionsEffect
extends OneShotEffect {
    DarkSuspicionsEffect() {
        super(Outcome.LoseLife);
        this.staticText = "that player loses X life, where X is the number of cards in that player's hand minus the number of cards in your hand";
    }

    public DarkSuspicionsEffect(DarkSuspicionsEffect effect) {
        super((OneShotEffect)effect);
    }

    public DarkSuspicionsEffect copy() {
        return new DarkSuspicionsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && opponent != null) {
            int xValue = opponent.getHand().size() - controller.getHand().size();
            if (xValue > 0) {
                opponent.loseLife(xValue, game, source, false);
            }
            return true;
        }
        return false;
    }
}

