/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DarkTemperEffect
extends OneShotEffect {
    DarkTemperEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 2 damage to target creature. If you control a black permanent, destroy the creature instead";
    }

    private DarkTemperEffect(DarkTemperEffect effect) {
        super((OneShotEffect)effect);
    }

    public DarkTemperEffect copy() {
        return new DarkTemperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        FilterPermanent filter = new FilterPermanent("black permanent");
        filter.add((Predicate)new ColorPredicate(ObjectColor.BLACK));
        if (game.getBattlefield().countAll(filter, source.getControllerId(), game) == 0) {
            permanent.damage(2, source.getSourceId(), source, game, false, true);
        } else {
            permanent.destroy(source, game, false);
        }
        return true;
    }
}

