/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class DarkbladeAgentWatcher
extends Watcher {
    private final Set<UUID> surveiledThisTurn = new HashSet<UUID>();

    public DarkbladeAgentWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SURVEILED) {
            this.surveiledThisTurn.add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.surveiledThisTurn.clear();
    }

    public boolean getSurveiledThisTurn(UUID playerId) {
        return this.surveiledThisTurn.contains(playerId);
    }
}

