/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.condition.CompoundCondition;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceIsSpellCondition;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.cards.d.IsBeingCastFromHandCondition;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorlessPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DarksteelMonolithAlternativeCost
extends AlternativeCostSourceAbility {
    private static final FilterCard filter = new FilterCard();
    private boolean wasActivated;

    DarksteelMonolithAlternativeCost() {
        super((Cost)new ManaCostsImpl("{0}"), (Condition)new CompoundCondition(new Condition[]{SourceIsSpellCondition.instance, IsBeingCastFromHandCondition.instance}), null, filter, true);
    }

    private DarksteelMonolithAlternativeCost(DarksteelMonolithAlternativeCost ability) {
        super((AlternativeCostSourceAbility)ability);
        this.wasActivated = ability.wasActivated;
    }

    public DarksteelMonolithAlternativeCost copy() {
        return new DarksteelMonolithAlternativeCost(this);
    }

    public boolean activateAlternativeCosts(Ability ability, Game game) {
        if (!super.activateAlternativeCosts(ability, game)) {
            return false;
        }
        Permanent monolith = game.getPermanent(this.getSourceId());
        if (monolith != null) {
            game.getState().setValue(monolith.getId().toString() + monolith.getZoneChangeCounter(game) + monolith.getTurnsOnBattlefield(), (Object)true);
        }
        return true;
    }

    static {
        filter.add((Predicate)ColorlessPredicate.instance);
    }
}

