/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class DauntingDefenderEffect
extends PreventionEffectImpl {
    DauntingDefenderEffect(int amount) {
        super(Duration.WhileOnBattlefield, amount, false, false);
        this.staticText = "If a source would deal damage to a Cleric creature you control, prevent " + amount + " of that damage";
    }

    private DauntingDefenderEffect(DauntingDefenderEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        if (event.getType() == GameEvent.EventType.DAMAGE_PERMANENT && (permanent = game.getPermanent(event.getTargetId())) != null && permanent.isControlledBy(source.getControllerId()) && permanent.isCreature(game) && permanent.hasSubtype(SubType.CLERIC, game)) {
            return super.applies(event, source, game);
        }
        return false;
    }

    public DauntingDefenderEffect copy() {
        return new DauntingDefenderEffect(this);
    }
}

